<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$setup = $this;

$setup->startSetup();

$entityTypeId = $setup->getEntityTypeId("customer");
$attributeSetId = $setup->getDefaultAttributeSetId($entityTypeId);
$attributeGroupId = $setup->getDefaultAttributeGroupId($entityTypeId, $attributeSetId);

$setup->addAttribute("customer", "awardit_totmemberinhouse",  array(
    "type" => "int",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Organization Employee Count",
    "input" => "text",
    "source" => "",
    "sort_order" => 330,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "Number of employees in the organization, totmemberinhouse",
));

$setup->addAttribute("customer", "awardit_mailnotify",  array(
    "type" => "int",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit Email Notification",
    "input" => "text",
    "source" => "",
    "sort_order" => 340,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "If the customer is accepting email notifications, (175 = ja, 176 = nej)",
));

$setup->addAttribute("customer", "awardit_usertype",  array(
    "type" => "int",
    "nullable" => true,
    "backend"  => "",
    "label" => "Awardit User Type",
    "input" => "text",
    "source" => "",
    "sort_order" => 350,
    "visible" => true,
    "required" => false,
    "default" => null,
    "frontend" => "",
    "unique" => false,
    "note" => "",
));

foreach([
    "awardit_totmemberinhouse" => ["position" => 330],
    "awardit_mailnotify" => ["position" => 340],
    "awardit_usertype" => ["position" => 350],
] as $attributeCode => $conf) {
    $setup->addAttributeToGroup(
        $entityTypeId,
        $attributeSetId,
        $attributeGroupId,
        $attributeCode,
        $conf["position"]
    );

    // We need to manually add the attribute here to be able to see it in admin
    $attribute = Mage::getSingleton("eav/config")->getAttribute("customer", $attributeCode);

    if( ! $attribute) {
        throw new Exception("Could not load customer attribute $attributeCode");
    }

    $attribute->setData("used_in_forms", ["adminhtml_customer"]);

    $attribute->save();
}

$setup->endSetup();