<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$conn = $installer->getConnection();

$amountType = [
    "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "nullable" => false,
    "default" => 0,
    "precision" => 10,
    "scale" => 2,
];

$conn->addColumn($this->getTable("sales/order"), "base_awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "base_awardit_amount_invoiced", array_merge($amountType, ["comment" => "Amount invoiced using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "base_awardit_amount_refunded", array_merge($amountType, ["comment" => "Amount refunded using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_amount_invoiced", array_merge($amountType, ["comment" => "Amount invoiced in Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_amount_refunded", array_merge($amountType, ["comment" => "Amount refunded in Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_points", array_merge($amountType, ["comment" => "The number of points spent from Awardit"]));
$conn->addColumn($this->getTable("sales/order"), "awardit_rate", array_merge($amountType, ["default" => 1, "comment" => "Numper of Awardit points per unit of currency"]));

$conn->addColumn($this->getTable("sales/quote"), "base_awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/quote"), "awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/quote"), "awardit_points", array_merge($amountType, ["comment" => "The number of points spent from Awardit"]));
$conn->addColumn($this->getTable("sales/quote"), "awardit_rate", array_merge($amountType, ["default" => 1, "comment" => "Numper of Awardit points per unit of currency"]));

$conn->addColumn($this->getTable("sales/invoice"), "base_awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/invoice"), "awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/invoice"), "awardit_points", array_merge($amountType, ["comment" => "The number of points spent from Awardit"]));
$conn->addColumn($this->getTable("sales/invoice"), "awardit_rate", array_merge($amountType, ["default" => 1, "comment" => "Numper of Awardit points per unit of currency"]));

$conn->addColumn($this->getTable("sales/creditmemo"), "base_awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points in base currency, not part of tax total"]));
$conn->addColumn($this->getTable("sales/creditmemo"), "awardit_amount", array_merge($amountType, ["comment" => "Amount spent using Awardit points, not part of tax total"]));
$conn->addColumn($this->getTable("sales/creditmemo"), "awardit_points", array_merge($amountType, ["comment" => "The number of points spent from Awardit"]));
$conn->addColumn($this->getTable("sales/creditmemo"), "awardit_rate", array_merge($amountType, ["default" => 1, "comment" => "Numper of Awardit points per unit of currency"]));
