<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$conn = $installer->getConnection();
$priceAttribute = Mage::getSingleton("eav/config")->getAttribute("catalog_product", "price");

if( ! $priceAttribute) {
    throw new Exception(sprintf(
        "%s: Missing catalog_product attribute price",
        __FILE__
    ));
}

$pointTable = $installer->getTable("points_core/product_price");
$productTable = $installer->getTable("catalog/product");
$productPriceTable = $installer->getTable("catalog/product")."_decimal";
$priceAttributeId = $priceAttribute->getId();
$customerGroupId = Mage_Customer_Model_Group::NOT_LOGGED_IN_ID;
$helper = Mage::helper("awardit_points");

foreach(Mage::app()->getStores() as $store) {
    $rate = $helper->getRate($store);
    $storeId = $store->getId();

    $conn->query("INSERT IGNORE INTO $pointTable (product_id, store_id, customer_group_id, type, price, min_price)
        SELECT e.entity_id, $storeId, $customerGroupId, 'awardit', COALESCE(ps.value, p.value, 0) * $rate, 0
        FROM $productTable e
        LEFT JOIN $productPriceTable p ON e.entity_id = p.entity_id AND p.attribute_id = $priceAttributeId AND p.store_id = 0
        LEFT JOIN $productPriceTable ps ON e.entity_id = ps.entity_id AND ps.attribute_id = $priceAttributeId AND ps.store_id = $storeId
        WHERE p.value IS NOT NULL OR ps.value IS NOT NULL");
}
