<?php

declare(strict_types=1);

use MageQL\Context;

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_Points_Model_Customer_Affiliate extends Mage_Core_Model_Abstract
{
    public const SUCCESS = "success";
    public const NOT_ACTIVATED = "notActivated";
    public const ERROR_NOT_LOGGED_IN = "errorNotLoggedIn";

    /**
     * @param mixed $unusedSrc
     */
    public static function mutateActivate(
        $unusedSrc,
        array $args,
        Context $ctx
    ): string {
        $store = $ctx->getStore();
        $helper = Mage::helper("awardit_points");
        $api = Mage::getSingleton("awardit_points/api");
        $javaSession = $helper->getJavaSession();

        if (! $javaSession) {
            return self::ERROR_NOT_LOGGED_IN;
        }

        if ($api->activatePartner($store, $javaSession, $args["id"])) {
            return self::SUCCESS;
        }

        return self::NOT_ACTIVATED;
    }
}
