<?php
/**
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License (GPL 3)
 * that is bundled with this package in the file LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Payone to newer
 * versions in the future. If you wish to customize Payone for your
 * needs please refer to http://www.payone.de for more information.
 *
 * @category        Payone
 * @package         Payone_Settings
 * @subpackage      Data
 * @copyright       Copyright (c) 2012 <info@payone.de> - www.noovias.com
 * @author          Matthias Walter <info@noovias.com>
 * @license         <http://www.gnu.org/licenses/> GNU General Public License (GPL 3)
 * @link            http://www.noovias.com
 */

/**
 *
 * @category        Payone
 * @package         Payone_Settings
 * @subpackage      Data
 * @copyright       Copyright (c) 2012 <info@noovias.com> - www.noovias.com
 * @license         <http://www.gnu.org/licenses/> GNU General Public License (GPL 3)
 * @link            http://www.noovias.com
 */
class Payone_Settings_Data_ConfigFile_PaymentMethod_Creditcard
    extends Payone_Settings_Data_ConfigFile_PaymentMethod_Abstract
    implements Payone_Settings_Data_ConfigFile_Interface
{
    /** @var string */
    protected $key = Payone_Enum_ClearingType::CREDITCARD;

    /** @var string */
    protected $cvc2 = '';

    /** @var string */
    protected $hide_cvc = '';

    /**
     * @return string
     */
    public function getClearingType()
    {
        return $this->key;
    }

    /**
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param string $cvc2
     */
    public function setCvc2($cvc2)
    {
        $this->cvc2 = $cvc2;
    }

    /**
     * @return string
     */
    public function getCvc2()
    {
        return $this->cvc2;
    }

    /**
     * @param $hide_cvc
     */
    public function setHideCvc($hide_cvc)
    {
        $this->hide_cvc = $hide_cvc;
    }

    /**
     * @return string
     */
    public function getHideCvc()
    {
        return $this->hide_cvc;
    }

    /**
     * @param $value
     */
    public function addHideCvc($value)
    {
        $this->hide_cvc[] = $value;
    }


}
