<?php
/**
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License (GPL 3)
 * that is bundled with this package in the file LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Payone_Core to newer
 * versions in the future. If you wish to customize Payone_Core for your
 * needs please refer to http://www.payone.de for more information.
 *
 * @category        Payone
 * @package         Payone_Core_Model
 * @subpackage      Payment
 * @copyright       Copyright (c) 2012 <info@noovias.com> - www.noovias.com
 * @author          Matthias Walter <info@noovias.com>
 * @license         <http://www.gnu.org/licenses/> GNU General Public License (GPL 3)
 * @link            http://www.noovias.com
 */

/**
 *
 * @category        Payone
 * @package         Payone_Core_Model
 * @subpackage      Payment
 * @copyright       Copyright (c) 2012 <info@noovias.com> - www.noovias.com
 * @license         <http://www.gnu.org/licenses/> GNU General Public License (GPL 3)
 * @link            http://www.noovias.com
 */
class Payone_Core_Model_Payment_Method_Creditcard extends Payone_Core_Model_Payment_Method_Abstract
{
    protected $methodType = Payone_Core_Model_System_Config_PaymentMethodType::CREDITCARD;

    protected $_code = Payone_Core_Model_System_Config_PaymentMethodCode::CREDITCARD;

    protected $_formBlockType = 'payone_core/payment_method_form_creditcard';
    protected $_infoBlockType = 'payone_core/payment_method_info_creditcard';
    protected $_canSaveCc = true;

    /** @var Payone_Core_Model_Config_Payment_Method_Interface[] */
    protected $matchingConfigs = array();

    /**
     * @api
     *
     * To be used in Form_Block, which has to display all creditcard types
     *
     * @param Mage_Sales_Model_Quote $quote
     * @return Payone_Core_Model_Config_Payment_Method_Interface
     */
    public function getAllConfigsByQuote(Mage_Sales_Model_Quote $quote)
    {
        if (empty($this->matchingConfigs)) {
            $configStore = $this->getConfigStore($quote->getStoreId());

            $this->matchingConfigs = $configStore->getPayment()->getMethodsForQuote($this->methodType, $quote);
        }

        return $this->matchingConfigs;
    }

    public function assignData($data)
    {
        if (empty($data->getData('cc_exp_month')) || empty($data->getData('cc_exp_year'))) {
            $expDate = $data->getData('payone_cardexpiredate');
            if (!empty($expDate)) {
                $data->setData('cc_exp_year', substr($expDate, 0, 2));
                $data->setData('cc_exp_month', substr($expDate, 2, 2));
            }
        }

        return parent::assignData($data);
    }

}