# Payone payment solution

Adds payment methods for [Payone](https://www.payone.com/), a provider specialised on Germany, Austria and Switzerland.
They support multiple payment types, including but not limited to creditcard, banktransfer, different invoice types,
Apple Pay, Amazon Pay, PayPal, and many more. They also have solutions for instore selling and channels.

## The fork

This is a fork of [Payone Magento-1](https://packagist.org/packages/payone-gmbh/magento-1)
with some changes (see below) and added code to enable payments over GraphQL interface.

* Branch `master` is the upstream. Do **not** commit changes here.
* Branch `main` is the adjusted code to be used in Awardit installations.

## Adjusted from source

* `composer.json` has added Awardit dependencies.
* Various environment files (such as phpunit, psalm, etc) has been added.
* All payments has added active property in `code/comminity/Payone/Core/etc/config.xml`.
* `<payment><rewrite><data>` instruction has been removed from `code/comminity/Payone/Core/etc/config.xml`. Instead there's a corresponding rewrite in `code/comminity/Awardit/Payone/etc/config.xml`
* MageQL configs in `code/comminity/Awardit/Payone/etc/config.xml`.
* Awardit specific code in `lib/Awardit`.
* Some original Payone files has been kept in `payone-original/`.
* Some Payone methods disabled in config as they cause errors. If needed, look into why they crash and activate them.

## How to use

The idea is that all Payone methods will have a common interface.
Differences in requirements and expectations will be specified in returned data so the client knows how to proceed.

### List available payment methods

This query will return a list of all generally available methods. 
Note that some methods might not be selectable with current user specified data.
All Payone methods will begin with `payone_`.

```graphql
query {
    paymentMethods {
        code 
        title
    }
}
```
Example result;
```json
{
    "data": {
        "paymentMethods": [
            {
                "code": "payone_online_bank_transfer_giropay",
                "title": "Test for payone_online_bank_transfer_giropay"
            },
            {
                "code": "payone_wallet_wechatpay",
                "title": "Test for payone_wallet_wechatpay"
            },
            {
                "code": "payone_online_bank_transfer_trustly",
                "title": "Test for payone_online_bank_transfer_trustly"
            },
            {
                "code": "payone_wallet_alipay",
                "title": "Test for payone_wallet_alipay"
            }
        ]
    }
}
```

### Select a Payone method

All Payone methods are selected the same way.
Will give result `success` if usable with current data, or an error if not.

```graphql
mutation {
    setQuotePaymentMethod {
        payone_online_bank_transfer_giropay {
            result
        }
    }
}
```
Example result;
```json
{
    "data": {
        "setQuotePaymentMethod": {
            "payone_online_bank_transfer_giropay": {
                "result": "success"
            }
        }
    }
}
```
> **Note**
> The response is expected to be expanded with additional properties in order to state requirements and expectations for further use.

### Check selected method on current quote

```graphql
query {
    quote {
        payment {
            code
        }
    }
}
```
Example result;
```json
{
    "data": {
        "quote": {
            "payment": {
                "code": "payone_online_bank_transfer_giropay"
            }
        }
    }
}
```