<?php
/**
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License (GPL 3)
 * that is bundled with this package in the file LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Payone to newer
 * versions in the future. If you wish to customize Payone for your
 * needs please refer to http://www.payone.de for more information.
 *
 * @category        Payone
 * @package         Payone_Api
 * @subpackage      Request
 * @copyright       Copyright (c) 2015 <kontakt@fatchip.de> - www.fatchip.com
 * @author          Robert M�ller <robert.mueller@fatchip.de>
 * @license         <http://www.gnu.org/licenses/> GNU General Public License (GPL 3)
 * @link            http://www.fatchip.com
 */

class Payone_Api_Request_Parameter_Authorization_PaymentMethod_PaymentGuaranteeInvoice
    extends Payone_Api_Request_Parameter_Authorization_PaymentMethod_Abstract
{
    /**
     * @var string
     */
    protected $clearingsubtype = null;

    /**
     * @var Payone_Api_Request_Parameter_Paydata_Paydata
     */
    protected $paydata = null;

    /**
     * @var string
     */
    protected $birthday = null;

    /**
     * @var string
     */
    protected $businessrelation = null;

    public function setClearingsubtype()
    {
        $this->clearingsubtype = 'POV';
    }

    /**
     * @return string
     */
    public function getClearingsubtype()
    {
        return $this->clearingsubtype;
    }

    /**
     * @param Payone_Api_Request_Parameter_Paydata_Paydata $paydata
     */
    public function setPaydata($paydata)
    {
        $this->paydata = $paydata;
    }

    /**
     * @return Payone_Api_Request_Parameter_Paydata_Paydata
     */
    public function getPaydata()
    {
        return $this->paydata;
    }

    /**
     * @param string $birthday
     */
    public function setBirthday($birthday)
    {
        $this->birthday = $birthday;
    }

    /**
     * @return string
     */
    public function getBirthday()
    {
        return $this->birthday;
    }

    /**
     * @return string
     */
    public function getBusinessrelation()
    {
        return $this->businessrelation;
    }

    /**
     * @param string $businessrelation
     */
    public function setBusinessrelation($businessrelation)
    {
        $this->businessrelation = $businessrelation;
    }
}
