<?php

declare(strict_types=1);

class Awardit_Opensearch_Model_Product_Collection_Search extends MageQL_Catalog_Model_Product_Collection_Search
{
    /**
     * Full text search
     *
     * @param Mage_Core_Model_Store $_store
     * @param Mage_CatalogSearch_Model_Query $query
     * @param string $term
     * @return array Found data
     */
    protected function fulltextSearch(
        Mage_Core_Model_Store $_store,
        Mage_CatalogSearch_Model_Query $query,
        string $term
    ): array {
        $enabled = (bool) $_store->getConfig(Awardit_Opensearch_Helper_Data::CONFIG_ENABLED) ?: false;

        if (!$enabled) {
            return parent::fulltextSearch($_store, $query, $term);
        }

        $opensearch = new Awardit_Opensearch_Model_Catalog_Opensearch($_store);
        return $opensearch->search($term);
    }
}
