<?php

declare(strict_types=1);

use OpenSearch\Client;

class Awardit_Opensearch_Model_Catalog_Opensearch
{
    /** @var Client */
    private $client;
    /** @var Mage_Core_Model_Store */
    private $store;

    public function __construct(Mage_Core_Model_Store $store)
    {
        $this->store = $store;
        $helper = Mage::helper('awardit_opensearch');
        $customCurlParams = [
            'client' => [
                'curl' => [
                    CURLOPT_CONNECTTIMEOUT => 3,
                ]
            ]
        ];
        $this->client = $helper->getClient($store, $customCurlParams);
    }

    public function search(string $term): array
    {
        $search = $this->searchRaw($term);
        $results = [];

        if (!isset($search['hits']['hits'])) {
            // No hits
            return $results;
        }

        foreach ($search['hits']['hits'] as $hit) {
            $results[$hit['_source']['entity_id']] = $hit['_score'];
        }
        return $results;
    }

    private function searchRaw(string $term): array
    {
        $params = [
            'index' => $this->store->getCode(),
            'body' => [
                '_source' => ['entity_id'],
                'size' => 320,
                'query' => [
                    'multi_match' => [
                        'query' => $term,
                        'type' => 'best_fields',
                        'fields' => ["sku^10", "name^10", "manufacturer^3", "short_description", "description"],
                    ],
                ],
            ],
        ];
        $result = $this->client->search($params);
        return $result;
    }
}
