<?php

declare(strict_types=1);

use Awardit\MagentoPsr\Psr3\Logger;
use OpenSearch\Client;
use OpenSearch\ClientBuilder;

class Awardit_Opensearch_Helper_Data
{
    private const LOG_CHANNEL = 'opensearch';
    public const CONFIG_ENABLED = "awardit_opensearch/opensearch/enabled";
    public const CONFIG_HOST = "awardit_opensearch/opensearch/host";
    public const CONFIG_USERNAME = "awardit_opensearch/opensearch/username";
    public const CONFIG_PASSWORD = "awardit_opensearch/opensearch/password";

    private Logger $psrLogger;

    public function __construct()
    {
        $this->psrLogger = new Logger(self::LOG_CHANNEL);
    }
    /**
     * @return Array<Mage_Core_Model_Store>
     */
    public function getStores(): array
    {
        // Only return stores that have Opensearch enabled
        return array_filter(Mage::app()->getStores(), function ($store) {
            return (bool) $store->getConfig(self::CONFIG_ENABLED) ?: false;
        });
    }

    /**
     * @param Mage_Core_Model_Store|null $store
     * @return Client
     */
    public function getClient(Mage_Core_Model_Store $store = null, array $connectionParams = []): Client
    {
        $host = Mage::getStoreConfig(self::CONFIG_HOST, $store);
        $username = Mage::getStoreConfig(self::CONFIG_USERNAME, $store);
        $password = Mage::getStoreConfig(self::CONFIG_PASSWORD, $store);

        if (empty($connectionParams)) {
            $connectionParams = [
                'client' => [
                    'curl' => [
                        CURLOPT_CONNECTTIMEOUT => 10,
                    ]
                ]
            ];
        }

        return ClientBuilder::create()
            ->setHosts([$host])
            ->setBasicAuthentication($username, $password)
            ->setConnectionParams($connectionParams)
            ->build();
    }

    public function getPsrLogger(): Logger
    {
        return $this->psrLogger;
    }
}
