<?php

declare(strict_types=1);

use MageQL\Context;

/**
 * @psalm-import-type ProductFilterInput from MageQL_Catalog_Model_Product
 * @psalm-import-type ProductSortInput from MageQL_Catalog_Model_Product
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_Opensearch_Model_Product extends MageQL_Catalog_Model_Product
{
    /**
     * @param mixed $unusedSrc
     * @param array{
     *   term: string,
     *   page: ?int,
     *   pageSize: ?int,
     *   filter?:?Array<ProductFilterInput>,
     *   sort: ?ProductSortInput,
     * } $args
     */
    public static function resolveProductsBySearch(
        $unusedSrc,
        array $args,
        Context $ctx
    ): ?MageQL_Catalog_Model_Product_SortableCollectionInterface {
        $opensearchEnabled =
            (bool) $ctx->getStore()->getConfig(Awardit_Opensearch_Helper_Data::CONFIG_ENABLED) ?: false;

        $minLength = $ctx->getStore()->getConfig(Mage_CatalogSearch_Model_Query::XML_PATH_MIN_QUERY_LENGTH);

        if (strlen($args["term"]) < $minLength) {
            return null;
        }

        if ($opensearchEnabled) {
            /*
            check if there is an error with OpenSearch
            defaults to magento search in case of the problem
            */
            try {
                $collection = new Awardit_Opensearch_Model_Product_Collection_Search($ctx->getStore(), $args["term"]);
            } catch (\Throwable $e) {
                $collection = new MageQL_Catalog_Model_Product_Collection_Search($ctx->getStore(), $args["term"]);
            }
        } else {
            $collection = new MageQL_Catalog_Model_Product_Collection_Search($ctx->getStore(), $args["term"]);
        }
        $collection->setFilters($args["filter"] ?? []);
        $collection->setSort($args["sort"]);
        $collection->setPage($args["page"], $args["pageSize"]);

        return $collection;
    }
}
