<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_Opensearch_Model_Schema_Product extends MageQL_Core_Model_Schema_Abstract
{
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder
    {
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array
    {
        switch ($typeName) {
            case "Query":
                return [
                    "productsBySearch" =>
                        $this->field(
                            "SortableProductList",
                            "Filter products by a specified search term, null means the term is too short"
                        )
                        ->addArgument("term", $this->argument("String!", "Search term/phrase"))
                        ->addArgument(
                            "filter",
                            $this->argument("[ProductFilterInput!]", "Filter products by these filters")
                        )
                        ->addArgument(
                            "sort",
                            $this->argument("ProductSortInput", "Sorting to use for the products")
                                ->setDefaultValue(Awardit_Opensearch_Model_Product_Collection_Search::DEFAULT_SORT)
                        )
                        ->addArgument(
                            "pageSize",
                            $this->argument("Int", "Maximum number of products to list")
                                ->setDefaultValue(MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE)
                        )
                        ->addArgument(
                            "page",
                            $this->argument("Int", "Which page to show")
                                ->setDefaultValue(MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE)
                        )
                        ->setResolver("Awardit_Opensearch_Model_Product::resolveProductsBySearch"),
                ];
        }
        return [];
    }
}
