<?php

declare(strict_types=1);

namespace Awardit\MicrosoftTeamsWebhook\Test\Card;

use Awardit\MicrosoftTeamsWebhook\Exception\SchemaValidationException;
use Awardit\MicrosoftTeamsWebhook\Message;
use Awardit\MicrosoftTeamsWebhook\Test\Fixture\TestAdaptiveCard;
use Awardit\MicrosoftTeamsWebhook\Test\Fixture\TestWrongAdaptiveCard;
use PHPUnit\Framework\TestCase;

final class MessageTest extends TestCase {
    public function testRender(): void {
        $card = new TestAdaptiveCard([
            'bodyText' => 'This is an example text block',
        ]);
        $message = new Message($card);

        $expected = <<<'JSON'
        {
            "type": "message",
            "attachments": [{
                "contentType": "application/vnd.microsoft.card.adaptive",
                "contentUrl": null,
                "content": {
                    "type": "AdaptiveCard",
                    "$schema": "http://adaptivecards.io/schemas/adaptive-card.json",
                    "version": "1.5",
                    "body": [{
                        "type": "TextBlock",
                        "text": "This is an example text block",
                        "wrap": true,
                        "isVisible":true,
                        "isSubtle":false,
                        "style":"default"
                    }]
                }
            }]
        }
        JSON;

        $this->assertEquals(json_encode(json_decode($expected)), $message->render());
    }

    public function testCardValidation(): void {
        $card = new TestWrongAdaptiveCard([
            'bodyText' => 'This is an example text block',
        ]);

        $message = new Message($card);
        $this->expectException(SchemaValidationException::class);
        $message->render();
    }
}
