<?php

declare(strict_types=1);

namespace Awardit\MicrosoftTeamsWebhook\Test\Card;

use Awardit\MicrosoftTeamsWebhook\Test\Fixture\TestAdaptiveCard;
use PHPUnit\Framework\TestCase;

final class AdaptiveCardTest extends TestCase {
    public function testRender(): void {
        $card = new TestAdaptiveCard(['bodyText' => 'This is example text']);

        $expected = json_decode(<<<'JSON'
        {
            "contentType": "application/vnd.microsoft.card.adaptive",
            "contentUrl": null,
            "content": {
                "type": "AdaptiveCard",
                "$schema": "http://adaptivecards.io/schemas/adaptive-card.json",
                "version": "1.5",
                "body": [{
                    "type": "TextBlock",
                    "text": "This is example text",
                    "wrap": true
                }]
            }
        }
        JSON
        );

        $this->assertEquals($expected, $card->render());
    }
}
