<?php

namespace Awardit\MicrosoftTeamsWebhook;

use GuzzleHttp\Client;
use Awardit\MicrosoftTeamsWebhook\Message;

class Webhook {
    protected Client $client;
    protected string $url;

    public function __construct(string $url, Client $client = null) {
        $this->url = $url;
        $this->client = $client ?? new Client();
    }

    public function send(Message $message): string {
        $headers = [
            'Content-Type' => 'application/json',
        ];
        $body = $message->render();

        $response = $this->client->post(
            $this->url,
            [
                'headers' => $headers,
                'body' => $body,
            ]
        );
        return (string) $response->getBody();
    }
}