<?php

namespace Awardit\MicrosoftTeamsWebhook;

use Awardit\MicrosoftTeamsWebhook\Card\AbstractCard;
use Awardit\MicrosoftTeamsWebhook\Exception\SchemaValidationException;

class Message {
    protected AbstractCard $card;

    public function __construct(AbstractCard $card) {
        $this->card = $card;
    }

    public function render(): string {
        $realRenderedCard = $this->card->render();
        $renderedCard = $realRenderedCard;
        $result = $this->card->getValidator()->validate($renderedCard, $this->card->getSchema());

        if (!$result->isValid()) {
            throw new SchemaValidationException($result->error()->message());
        }
        return json_encode((object) [
            'type' => 'message',
            'attachments' => [ $renderedCard ],
        ]);
    }
}