<?php

namespace Awardit\MicrosoftTeamsWebhook\Card;

use Opis\JsonSchema\Validator;

class AdaptiveCard extends AbstractCard {
    public function getSchema(): string {
        return 'http://awardit.dev/adaptive-card.json';
    }

    public function getValidator(): Validator {
        $validator = new Validator();

        if ($resolver = $validator->resolver()) {
            $resolver->registerFile('http://adaptivecards.io/schemas/adaptive-card.json', realpath(dirname(__DIR__) . '/Schema/adaptivecards-io-adaptive-card.json'));
            $resolver->registerFile('http://awardit.dev/adaptive-card.json', realpath(dirname(__DIR__) . '/Schema//awardit.dev-adaptive-card.json'));
        }

        return $validator;
    }

    protected function renderBody(): array {
        return [];
    }

    protected function renderContent(): object {
        $body = $this->renderBody();
        return (object) [
            'type' => 'AdaptiveCard',
            '$schema' => 'http://adaptivecards.io/schemas/adaptive-card.json',
            'version' => '1.5',
            'body' => $body,
        ];
    }

    public function render(): object {
        return (object) [
            'contentType' => 'application/vnd.microsoft.card.adaptive',
            'contentUrl' => null,
            'content' => $this->renderContent(),
        ];
    }
}