# Microsoft Teams Webhook

This project is aimed at creating and sending webhooks to Microsoft Teams.

## Background

Webhooks for Microsoft teams accept POST requests that contains what is called [Adaptive cards](https://adaptivecards.io/).

The current implementation does not carry any data, so you must implement an instance of `Awardit\MicrosoftTeamsWebhook\Card\AdaptiveCard` that implements `renderBody()`.

## Usage/Examples

You must first define a card that has data.

```php
use Awardit\MicrosoftTeamsWebhook\Card\AdaptiveCard;

class GitlabAdaptiveCard extends AdaptiveCard {
    protected function renderBody(): array {
        return [(object) [
            'type' => 'TextBlock',
            'text' => $this->data['bodyText'] ?? '',
            'wrap' => true,
        ]];
    }
}
```

Then we can send a webhook message.

```php
use Awardit\MicrosoftTeamsWebhook\Message;
use Awardit\MicrosoftTeamsWebhook\Webhook;
use GitlabAdaptiveCard;

// Here we set the url we created at Microsoft Teams
$webhookUrl = 'https://example.com';
$webhook = new Webhook($webhookUrl);

$card = new GitlabAdaptiveCard([
    'bodyText' => 'This is an example text block',
]);
$message = new Message($card);

$webhook->send($message);
```