<?php

declare(strict_types=1);

use Awardit\Microauth\{
    JsonWebKeySet,
    JwtAuthenticator,
};
use Awardit\Microauth\Http\TokenAuthenticatorMiddleware;
use Awardit\Microauth\Test\Mock\RequestHandler;
use GuzzleHttp\Client;
use GuzzleHttp\Psr7\HttpFactory;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Logger;

require __DIR__ . '/../vendor/autoload.php';

$httpFactory = new HttpFactory();
$httpUri = $httpFactory->createUri('https://example.com/my-test-api');
$httpRequest = $httpFactory->createServerRequest("GET", "http://example.com/my-test-api");
$httpClient = new Client();
$logger = new Logger("microauth", [new ErrorLogHandler()]);

$keys = new JsonWebKeySet($httpUri, $httpClient, $httpFactory, $logger);
$authenticator = new JwtAuthenticator(
    keys: $keys,
    knownIssuers: ["test"],
    audience: "http://example.com/my-test-api",
);
$middleware = new TokenAuthenticatorMiddleware($authenticator, $httpFactory, $httpFactory, $logger);
$handler = new RequestHandler();

$httpResponse = $middleware->process($httpRequest, $handler);
echo "{$httpResponse->getStatusCode()} {$httpResponse->getReasonPhrase()}\n";
