#!/bin/sh

set -e

# TODO: look through all folders upwards
if [ -f "$PWD/.env" ]; then
	. "$PWD/.env"
fi

COMPOSER_IMAGE="${COMPOSER_IMAGE:-"registry.awardit.dev/crossroads/images/php:8.3-cli-composer"}"

# Logic to detect composer home
if [ -z "$COMPOSER_HOME" ] && [ -d "$HOME/.composer" ]; then
	# Legacy folder if it exists
	COMPOSER_HOME="$HOME/.composer"
else
	# Try XDG spec, and fallback to $HOME/.config/composer
	COMPOSER_HOME="${COMPOSER_HOME:-"${XDG_CONFIG_HOME:-"$HOME/.config"}/composer"}"
fi

# Make sure the directory exists before we attempt to mount it as a volume. If
# we mount it as a volume before it exists it will be created with the user and
# group root:root which will be problematic.
if [ ! -e "${COMPOSER_HOME}" ]; then
	echo "Creating ${COMPOSER_HOME} for current user"

	mkdir -p "${COMPOSER_HOME}"
fi

docker run --rm -it \
	-v "${PWD}:${PWD}" \
	-w "${PWD}" \
	-v "${COMPOSER_HOME-$HOME/.composer}:/composer" \
	-v "${HOME}/.ssh:/home/${USER}/.ssh:ro" \
	-v "composer-cache:/cache/composer" \
	--tmpfs "/tmp" \
	-e "UID=$(id -u)" -e "GID=$(id -g)" \
	-e "USER=$(id -u -n)" -e "GROUP=$(id -g -n)" \
	-e "XDG_CACHE_HOME=/tmp" \
	${COMPOSER_IMAGE} "$@"
