<?php

declare(strict_types=1);

namespace Awardit\Microauth;

/**
 * An authenticated token, representing a client or user.
 *
 * @api
 */
interface TokenInterface
{
    /**
     * The subject id of the token, null if the subject is anonymous.
     *
     * Subject id is globally unique and should be treated as an opaque string.
     * Subject can equal client id if the token identifies a service.
     */
    public function getSubjectId(): ?string;

    /**
     * The Client identifier, identifying the client application which
     * requested the token.
     *
     * Client id is globally unique.
     */
    public function getClientId(): string;

    /**
     * Session id, stable across multiple refreshes.
     *
     * Globally unique.
     */
    public function getSessionId(): string;
}
