<?php

declare(strict_types=1);

namespace Awardit\Microauth;

use Exception as BaseException;
use Throwable;

/**
 * Exception from Awardit Microauth library.
 */
class Exception extends BaseException
{
    public function __construct(
        string $message,
        ?Throwable $prev = null,
        /**
         * Log-context data.
         */
        public array $context = []
    ) {
        parent::__construct($message, 0, $prev);
    }

    /**
     * Returns extra log-context data, useful to debug configuration mistakes.
     */
    public function getContext(): array
    {
        return $this->context;
    }
}
