<?php

declare(strict_types=1);

namespace Awardit\Microauth;

use JsonSerializable;

/**
 * @api
 * @psalm-type TokenPayload array{
 *   aud?: list<string>,
 *   clientId?: string,
 *   exp?: int,
 *   iat?: int,
 *   iss?: string,
 *   jti?: string,
 *   name?: string,
 *   oid?: string,
 *   roles?: array<string>,
 *   sid?: string,
 *   sub?: string|null,
 *   user?: string,
 *   uti?: string,
 * }
 */
class AccessToken implements TokenInterface, JsonSerializable
{
    /**
     * @param TokenPayload $payload
     */
    public function __construct(
        /** @var TokenPayload $payload */
        private array $payload
    ) {
    }

    public function getTokenId(): string|null
    {
        // jti (standard) or uti (microsoft), depending on implementation
        return $this->payload['jti'] ?? $this->payload['uti'] ?? null;
    }

    public function getSubjectId(): string|null
    {
        return $this->payload['sub'] ?? null;
    }

    public function getClientId(): string
    {
        return $this->payload['clientId'] ?? '';
    }

    public function getSessionId(): string
    {
        return $this->payload['sid'] ?? '';
    }

    public function get(string $key): mixed
    {
        return $this->payload[$key] ?? null;
    }

    public function jsonSerialize(): array
    {
        return $this->payload;
    }
}
