# Tokens

All tokens are based on JSON Web Token specification.

## Token Header

{
  "typ": "JWT",
  "alg": "EdDSA",
  "crv": "Ed25519",
  "kid": "ab123",
}

### Fields

#### `typ`: Token Type

The token is always of type `"JWT"`, JSON Web Token.

#### `alg`: Key Algorithm

The algorithm used to sign the key. Should be obtained/verified using `kid`
to avoid spoofing the used algorithm.

#### `kid`: Key Identifier

A string identifying the key and algorithm used. MUST identify both to avoid
spoofing the used algorithm.

## Access Token

### Example

```json
{
  "jti": "2xVfgmz3vVaZxXLoRWdpj",
  "sid": "W-B1ulpFl2goYbWAol0_J",
  "sub": "awardit-entra/sdfhui321aav",
  "client_id": "someapp.awardit.com",
  "iss": "https://mu.auth.example.com",
  "aud": ["https://aws.awardit.com"],
  "iat": 1673612358,
  "exp": 1673607358,
}
```

### Fields

#### `jti`: JSON Token ID

String. Unique per token, cryptographic (p)RNG.

Useful for partial session-tracking, and token revocation.

TODO: Prefix?
TODO: length?
TODO: NanoID?

#### `sid`: Session ID

The session id this token is a part of. Stable across token refreshes and
privilege updates.

#### `sub`: Token Subject

The unique id of the token subject (user or service) which this token identifies.

Subject is obtained by prefixing an id provided by an Identity Provider with a
prefix identifying which Identity Provider was used.

Anonymous customers/users are always `"*"`.

TODO: separator for prefix and id? `:`? `/`?
TODO: Use some kind of URL-encoding for the separator, if present in the subject id?
TODO: How can we make it easy for a consumer of the token to understand that it
      is an anonymous user?

#### `iss`: Token Issuer

The service which issued the access token.

#### `aud`: Audience of token

List of strings (single string instead of list is allowed, should be converted to list).

The list of services/systems which are the intended recipients of the token.
This needs to be validated to ensure tokens are not misused, ie. tokens issued
for one purpose being used in completely different services.

TODO: How do we configure which audiences should be present in a token? Not all
      clients need these? Do we do this based on client which authenticated?

## Refresh Token

### Example

```json
{
  "jti": "t2ZokLOR4Kx1k6OjfSqLL",
  "iss": "https://mu.auth.awardit.com",
  "aud": ["https://mu.auth.example.com"],
  "iat": 1673612358,
  "exp": 1673607358,
}
```

### Fields

#### `jti`: JSON Token ID

String. Unique per token, cryptographic (p)RNG.

Useful for partial session-tracking, and token revocation.

#### `aud`: Audience of token

List of strings, or single string, identifying the intended recipient of the Refresh Token.

In this case it is the OAuth 2 service which issued the Refresh Token.
