<?php

declare(strict_types=1);

namespace Awardit\Microauth;

use JsonSerializable;

/**
 * @api
 * @psalm-suppress UnusedProperty
 */
class AccessToken implements TokenInterface, JsonSerializable
{
    /**
     * @internal
     * @psalm-internal Awardit\Microauth
     */
    public function __construct(
        private string $jti,
        private string $sid,
        private ?string $sub,
        private string $clientId,
        private string $iss,
        private array $aud,
        private int $iat,
        private int $exp,
    ) {
    }

    public function getSubjectId(): ?string
    {
        return $this->sub;
    }

    public function getClientId(): string
    {
        return $this->clientId;
    }

    public function getSessionId(): string
    {
        return $this->sid;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
