<?php

declare(strict_types=1);

use Awardit\Microauth\Http\TokenAuthenticatorMiddleware;
use Awardit\Microauth\JwtAuthenticator;
use Nyholm\Psr7\ServerRequest;
use Monolog\Handler\ErrorLogHandler;
use Monolog\Logger;

$log = new Logger("microauth", [new ErrorLogHandler()]);
$request = new ServerRequest("GET");

$keys = new JsonWebKeySet("https://mykeys");
$authenticator = new JwtAuthenticator(
    keys: $keys,
    knownIssuers: ["test"],
    audience: "http://example.com/my-test-api",
);
$middleware = new TokenAuthenticatorMiddleware($authenticator, $log);

var_dump($middleware->process($request));
