<?php

declare(strict_types=1);

namespace Awardit\Microauth\Test;

use Awardit\Microauth\{
    AccessToken,
    TokenInterface,
};
use JsonSerializable;
use PHPUnit\Framework\TestCase;

/** @psalm-suppress UnusedClass */
class AccessTokenTest extends TestCase
{
    public function testAccessToken(): void
    {
        $token = new AccessToken([
            'jti' => 'jti',
            'sid' => 'sid',
            'sub' => 'sub',
            'clientId' => 'clientId',
            'iss' => 'iss',
            'aud' => ['aud'],
            'iat' => 12,
            'exp' => 23,
        ]);
        $this->assertInstanceOf(TokenInterface::class, $token);
        $this->assertInstanceOf(JsonSerializable::class, $token);
        $this->assertEquals('sub', $token->getSubjectId());
        $this->assertEquals('clientId', $token->getClientId());
        $this->assertEquals('sid', $token->getSessionId());
        $this->assertEquals([
            'jti' => 'jti',
            'sid' => 'sid',
            'sub' => 'sub',
            'clientId' => 'clientId',
            'iss' => 'iss',
            'aud' => ['aud'],
            'iat' => 12,
            'exp' => 23,
        ], $token->jsonSerialize());
    }
}
