<?php

declare(strict_types=1);

namespace Awardit\Microauth;

/**
 * Interface for token authenticator.
 */
interface AuthenticatorInterface
{
    /**
     * Attempts to authenticate the given token, returning a valid
     * implementation of TokenInterface if it succeeds.
     *
     * @throws Exception if the configuration is not valid
     * @throws UnauthorizedException if token is not authorized
     * @throws ValidationException if token fails validation
     */
    public function authenticate(string $token): TokenInterface;
}
