<?php

declare(strict_types=1);

namespace Awardit\Microauth;

/**
 * An interface representing a subject which can have been granted
 * authorization to perform specific actions.
 *
 * @api
 */
interface AuthorizationInterface
{
    /**
     * Returns true if the client/user is allowed the given permission on the
     * (maybe specific) resource.
     */
    public function isGranted(
        string $permission,
        string $resource,
        ?string $resourceId = null
    ): bool;
}
