# User Stories

## User

### As a user I want to exchange a signed OpenID Connect ID-token for an identified session

Custom OAuth 2 flow with OpenID Connect + Client Credentials -> identified Refresh Token + Access Token.

### As a user I want a client to be able to obtain an anonymous session on my behalf.

OAuth 2 Client Credentials flow -> Refresh Token + Access Token with anonymous session.

### As a user I want to be able to promote an anonymous session to an identified session.

Custom OAuth 2 flow with supplied Refresh Token from anonymous session

### As a user I want to be able to list my currently logged in sessions

### As a user I want to be able to log out currently logged in sessions

## Service

### As a service I want to obtain an access token using Client Credentials

OAuth 2 Client Credentials flow -> Access Token for the particular client

## Maintainer

### As a maintainer I want to be able to rotate encryption-keys without interrupting any services

Maintainers need to be able to easily add additional keys to consumers, and
then swap over the primary signing key in the service issuing the tokens once
this new public key is available in the consumers.

### As a maintainer I want tokens to be completely devoid of personally identifiable information

No profile data or name/email/similar in the token itself.

### As a maintainer I want interactions with the token issuing service to track enough data to make it easy to prevent fraud and attacks

Save data like IP addresses, forwarded for, user agent, and so on for all interactions

### As a maintainer I want the token issuing service to make it easy to protect it from DDoS and craking attacks

## Administrator

### As an administrator I want to be able to map groups from the service
