<?php

/**
 * Override of admin newsletter subscriber list.
 */
class Ebizmarts_MailChimp_Block_Adminhtml_Newsletter_Subscriber_Grid extends Mage_Adminhtml_Block_Newsletter_Subscriber_Grid
{
    /**
     * @inheritDoc
     * @throws Exception
     */
    protected function _prepareColumns()
    {
        parent::_prepareColumns();

        $this->addColumnAfter('firstname', [
            'header'    => Mage::helper('newsletter')->__('Customer First Name'),
            'index'     => 'customer_firstname',
            'renderer'  => 'mailchimp/adminhtml_newsletter_subscriber_renderer_firstname',
        ], 'type');

        $this->addColumnAfter('lastname', [
            'header'    => Mage::helper('newsletter')->__('Customer Last Name'),
            'index'     => 'customer_lastname',
            'renderer'  => 'mailchimp/adminhtml_newsletter_subscriber_renderer_lastname',
        ], 'firstname');
    }
}