<?php

declare(strict_types=1);

class Awardit_SMTP_Model_Email_Queue extends Mage_Core_Model_Email_Queue {
    public function send() {
        $store = Mage::app()->getStore();
        $smtpHelper = Mage::helper("awardit_smtp");
        $transport = $smtpHelper->isEnabled($store) ? $smtpHelper->createTransport($store) : null;
        $collection = Mage::getResourceModel('core/email_queue_collection');

        $collection->addOnlyForSendingFilter();
        $collection->setPageSize(self::MESSAGES_LIMIT_PER_CRON_RUN);
        $collection->setCurPage(1);
        $collection->load();

        if($transport) {
            Mage::log(sprintf(
                "%s: SMTP is enabled, using it as transport",
                __METHOD__
            ));
        }

        ini_set('SMTP', Mage::getStoreConfig('system/smtp/host'));
        ini_set('smtp_port', Mage::getStoreConfig('system/smtp/port'));

        /** @var Mage_Core_Model_Email_Queue $message */
        foreach ($collection as $message) {
            if ($message->getId()) {
                $parameters = new Varien_Object($message->getMessageParameters());
                if ($parameters->getReturnPathEmail() !== null) {
                    $mailTransport = new Zend_Mail_Transport_Sendmail("-f" . $parameters->getReturnPathEmail());
                    Zend_Mail::setDefaultTransport($mailTransport);
                }

                $mailer = new Zend_Mail('utf-8');

                foreach ($message->getRecipients() as $recipient) {
                    list($email, $name, $type) = $recipient;
                    switch ($type) {
                        case self::EMAIL_TYPE_BCC:
                            $mailer->addBcc($email);
                            break;
                        case self::EMAIL_TYPE_TO:
                        case self::EMAIL_TYPE_CC:
                        default:
                            $mailer->addTo($email, '=?utf-8?B?' . base64_encode($name) . '?=');
                            break;
                    }
                }

                if ($parameters->getIsPlain()) {
                    $mailer->setBodyText($message->getMessageBody());
                } else {
                    $mailer->setBodyHtml($message->getMessageBody());
                }

                $mailer->setSubject('=?utf-8?B?' . base64_encode($parameters->getSubject()) . '?=');
                $mailer->setFrom($parameters->getFromEmail(), $parameters->getFromName());
                if ($parameters->getReplyTo() !== null) {
                    $mailer->setReplyTo($parameters->getReplyTo());
                }
                if ($parameters->getReturnTo() !== null) {
                    $mailer->setReturnPath($parameters->getReturnTo());
                }

                try {
                    $mailer->send($transport);
                    $message->setCompletedAt((string)Varien_Date::formatDate(true));
                } catch (Exception $e) {
                    Mage::logException($e);
                }

                unset($mailer);
                $message->setProcessedAt((string)Varien_Date::formatDate(true));
                $message->save();
            }
        }

        return $this;
    }
}
