<?php

declare(strict_types=1);

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_SMTP_Model_Email extends Mage_Core_Model_Email {
    public function send() {
        $helper = Mage::helper("awardit_smtp");
        $store = Mage::app()->getStore();

        if($store->getConfig("system/smtp/disable")) {
            return $this;
        }

        $transport = $helper->isEnabled($store) ? $helper->createTransport($store) : null;

        if($transport) {
            Mage::log(sprintf(
                "%s: SMTP is enabled, using it as transport",
                __METHOD__
            ));
        }

        $mail = new Zend_Mail();

        if (strtolower($this->getType()) == 'html') {
            $mail->setBodyHtml($this->getBody());
        } else {
            $mail->setBodyText($this->getBody());
        }

        $mail->setFrom($this->getFromEmail(), $this->getFromName())
            ->addTo($this->getToEmail(), $this->getToName())
            ->setSubject($this->getSubject());

        $mail->send($transport);

        return $this;
    }
}
