<?php

declare(strict_types=1);

class Awardit_SMTP_Helper_Data extends Mage_Core_Helper_Abstract {
    const CONFIG_ENABLED = "system/smtp/use_smtp";
    const CONFIG_HOST = "system/smtp/host";
    const CONFIG_PORT = "system/smtp/port";
    const CONFIG_AUTH = "system/smtp/auth";
    const CONFIG_USERNAME = "system/smtp/username";
    const CONFIG_PASSWORD = "system/smtp/password";
    const CONFIG_SSL = "system/smtp/ssl";

    public function isEnabled(Mage_Core_Model_Store $store): bool {
        return (bool)$store->getConfig(self::CONFIG_ENABLED);
    }

    public function getHost(Mage_Core_Model_Store $store): string {
        return (string)$store->getConfig(self::CONFIG_HOST);
    }

    public function getPort(Mage_Core_Model_Store $store): int {
        return (int)$store->getConfig(self::CONFIG_PORT);
    }

    public function getAuth(Mage_Core_Model_Store $store): ?string {
        $auth = strtolower(str_replace("-", "", (string)$store->getConfig(self::CONFIG_AUTH)));

        return (empty($auth) || $auth === "none") ? null : $auth;
    }

    public function getUsername(Mage_Core_Model_Store $store): string {
        return (string)$store->getConfig(self::CONFIG_USERNAME);
    }

    public function getPassword(Mage_Core_Model_Store $store): string {
        return (string)$store->getConfig(self::CONFIG_PASSWORD);
    }

    public function getSsl(Mage_Core_Model_Store $store): ?string {
        return (string)$store->getConfig(self::CONFIG_SSL) ?: null;
    }

    public function createTransport(Mage_Core_Model_Store $store): Zend_Mail_Transport_Abstract {
        $ssl = $this->getSsl($store);
        $config = [
            'username' => $this->getUsername($store),
            'password' => $this->getPassword($store),
            'port' => $this->getPort($store),
            'auth' => $this->getAuth($store),
        ];

        if($ssl) {
            $config['ssl'] = $ssl;
        }

        return new Zend_Mail_Transport_Smtp($this->getHost($store), $config);
    }
}
