<?php

declare(strict_types=1);

namespace Awardit\MagentoPsr\Psr3\Context;

use Zend_Controller_Request_Http;
use Zend_Controller_Response_Http;

/**
 * Log resolver for Zend Http types.
 */
class ZendHttpResolver implements ResolverInterface
{
    /** @param mixed $context */
    public function canResolve($context): bool
    {
        return $context instanceof Zend_Controller_Request_Http
            || $context instanceof Zend_Controller_Response_Http;
    }

    /** @param mixed $context */
    public function resolve($context): Context
    {
        if ($context instanceof Zend_Controller_Request_Http) {
            return $this->normalizeHttpRequest($context);
        }
        return $this->normalizeHttpResponse($context);
    }

    private function normalizeHttpRequest(Zend_Controller_Request_Http $request): Context
    {
        return new Context("{$request->getMethod()} {$request->getRequestUri()}", [
            'method' => $request->getMethod(),
            'uri' => $request->getRequestUri(),
            'body' => (string)$request->getRawBody(),
        ]);
    }

    private function normalizeHttpResponse(Zend_Controller_Response_Http $response): Context
    {
        return new Context((string)$response->getHttpResponseCode(), [
            'status' => $response->getHttpResponseCode(),
            'body' => $response->getBody(),
        ]);
    }
}
