<?php

declare(strict_types=1);

namespace Awardit\MagentoPsr\Psr3\Context;

use Psr\Http\Message\{
    MessageInterface,
    RequestInterface,
    ResponseInterface
};

/**
 * Log resolver for PSR-3 Http types.
 */
class PsrHttpResolver implements ResolverInterface
{
    /** @param mixed $context */
    public function canResolve($context): bool
    {
        return $context instanceof MessageInterface;
    }

    /** @param mixed $context */
    public function resolve($context): Context
    {
        if ($context instanceof RequestInterface) {
            return $this->normalizeHttpRequest($context);
        }
        return $this->normalizeHttpResponse($context);
    }

    private function normalizeHttpRequest(RequestInterface $request): Context
    {
        return new Context("{$request->getMethod()} {$request->getUri()}", [
            'method' => $request->getMethod(),
            'uri' => (string)$request->getUri(),
            'version' => $request->getProtocolVersion(),
            'headers' => $request->getHeaders(),
            'body' => (string)$request->getBody(),
        ]);
    }

    private function normalizeHttpResponse(ResponseInterface $response): Context
    {
        return new Context((string)$response->getStatusCode(), [
            'status' => $response->getStatusCode(),
            'version' => $response->getProtocolVersion(),
            'headers' => $response->getHeaders(),
            'body' => (string)$response->getBody(),
        ]);
    }
}
