<?php

declare(strict_types=1);

namespace Awardit\MagentoPsr\Psr3\Context;

use JsonSerializable;

/**
 * Log resolver for standard types.
 */
class DefaultResolver implements ResolverInterface
{
    /** @param mixed $context */
    public function canResolve($context): bool
    {
        return true;
    }

    /** @param mixed $context */
    public function resolve($context): Context
    {
        if (is_bool($context)) {
            return new Context($context ? 'true' : 'false', $context);
        }
        if (is_null($context)) {
            return new Context('null', $context);
        }
        if (is_scalar($context)) {
            return new Context((string)$context, $context);
        }
        if (is_array($context)) {
            $data = array_map(
                /**
                 * @param mixed $item
                 * @return mixed
                 */
                function ($item) {
                    return $this->resolve($item)->jsonSerialize();
                },
                $context
            );
            return new Context('array', $data);
        }
        if (is_object($context)) {
            $ref = method_exists($context, '__toString') ? (string)$context : get_class($context);
            $data = $context instanceof JsonSerializable ? $context->jsonSerialize() : get_class($context);
            return new Context($ref, $data);
        }
        return new Context(gettype($context), null);
    }
}
