<?php

declare(strict_types=1);

namespace Awardit\MagentoPsr\Psr3\Context;

use JsonSerializable;

/**
 * Context wrapper class.
 */
class Context implements JsonSerializable
{
    private string $reference;
    /** @var mixed data */
    private $data;

    /** @param mixed $data */
    public function __construct(string $reference, $data)
    {
        $this->reference = $reference;
        $this->data = $data;
    }

    public function __toString(): string
    {
        return $this->reference;
    }

    public function jsonSerialize()
    {
        return $this->data;
    }
}
