<?php
/** @var Mage_Core_Model_Resource_Setup $this */
$installer = $this;
$connection = $installer->getConnection();

$tableOrder = $installer->getTable('sales/order');
$tableQuote = $installer->getTable('sales/quote');

// Add to sales_order table if not exists
if (!$connection->tableColumnExists($tableOrder, 'external_order_api_metadata')) {
    $connection->query("ALTER TABLE {$tableOrder}
        ADD COLUMN external_order_api_metadata JSON COMMENT 'External Order API Metadata (JSON format)',
        ADD CONSTRAINT external_order_api_metadata_is_valid_json
        CHECK (JSON_VALID(external_order_api_metadata))");
}

// Add to sales_quote table if not exists
if (!$connection->tableColumnExists($tableQuote, 'external_order_api_metadata')) {
    $connection->query("ALTER TABLE {$tableQuote}
        ADD COLUMN external_order_api_metadata JSON COMMENT 'External Order API Metadata (JSON format)',
        ADD CONSTRAINT external_order_api_metadata_is_valid_json
        CHECK (JSON_VALID(external_order_api_metadata))");
}
