<?php

declare(strict_types=1);

class Awardit_OrderApi_UnauthorizedException extends Exception implements Awardit_OrderApi_ResponseException {
    public function __construct() {
        parent::__construct("Unauthorized OrderApi call");
    }

    public function getHttpResponseCode(): int {
        return 401;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json; charset=utf-8",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => "Unauthorized OrderApi call",
            "code" => "unauthorized",
        ]);
    }

    public function getErrorLevel(): int {
        return Zend_Log::WARN;
    }
}
