<?php

declare(strict_types=1);

class Awardit_OrderApi_ProductNotFoundException extends Exception implements Awardit_OrderApi_ResponseException {
    private string $sku;

    public function __construct(string $sku) {
        parent::__construct("Product with SKU '$sku' does not exist");

        $this->sku = $sku;
    }

    public function getHttpResponseCode(): int {
        return 400;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json; charset=utf-8",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => $this->getMessage(),
            "code" => "productNotFound",
            "data" => [
                "sku" => $this->sku,
            ],
        ]);
    }

    public function getErrorLevel(): int {
        return Zend_Log::NOTICE;
    }
}
