<?php

/** @var Mage_Core_Model_Resource_Setup $this */
$installer = $this;
$connection = $installer->getConnection();

$connection->addColumn(
    $installer->getTable("sales/order"),
    "external_order_api_unique_id",
    [
        "type" => "text",
        "nullable" => true,
        "default" => null,
        "comment" => "Unique external id for an order",
    ],
);
$connection->addColumn(
    $installer->getTable("sales/quote"),
    "external_order_api_unique_id",
    [
        "type" => "text",
        "nullable" => true,
        "default" => null,
        "comment" => "Unique external id for an order, not enforced in quote",
    ],
);

$connection->addIndex(
    $installer->getTable("sales/order"),
    $installer->getIdxName("sales/quote", ["store_id", "external_order_api_unique_id"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["store_id", "external_order_api_unique_id"],
    Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE,
);
