# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.3.0] - 2024-11-13
### Added
- Support for bundle products with all required items pre-populated.
- POST `orders` now accepts an `externalUniqueId` body parameter which will
  prevent multiple orders with the same id from being created. Duplicates will
  return the previously created order.
- Orders response `externalReference`
- Orders response `externalUniqueId`

## [1.2.1] - 2024-10-21
### Changed
- MageQL-libraries are no longer required.

## [1.2.1] - 2023-02-13
### Added
- Product.stock.qty containing approximate product stock quantity.

## [1.2.0] - 2022-10-10
### Added
- Optional boolean query-parameter `enabled` on Product endpoint to filter
  products based on if they are enabled or disabled.
### Fixed
- Product endpoint `limit` query parameter is now clamped to 1 to 500 instead
  of defaulting to 100 if outside of range.

## [1.1.0] - 2022-10-05
### Added
- `code` property in error-responses.
- Different error-levels for error-response logging.
- Error-handling for attempts to order out of stock products.
### Fixed
- Order item `qty` parameter is now properly respected.
- Multiple `Content-Type` headers specified in error-responses.
- Use UTF-8 charset in error responses.

## [1.0.3] - 2022-09-29
### Fixed
- Limit listed categories to store root category.

## [1.0.2] - 2022-09-29
### Fixed
- Category name is now properly loaded.

## [1.0.1] - 2022-09-29
### Fixed
- `POST /order` response code on success is now 201 Created to match documentation.
