<?php

declare(strict_types=1);

class Awardit_OrderApi_DisabledException extends Exception implements Awardit_OrderApi_ResponseException {
    public function __construct() {
        parent::__construct("OrderApi is disabled");
    }

    public function getHttpResponseCode(): int {
        // TODO: Is this a good response?
        return 404;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => "OrderApi is disabled",
        ]);
    }
}
