<?php

declare(strict_types=1);

class Awardit_OrderApi_JsonParseException extends Exception implements Awardit_OrderApi_ResponseException {
    public function __construct() {
        parent::__construct("Failed to parse JSON body");
    }

    public function getHttpResponseCode(): int {
        return 400;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json; charset=utf-8",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => "Invalid JSON format",
            "code" => "jsonParseError",
        ]);
    }

    public function getErrorLevel(): int {
        return Zend_Log::DEBUG;
    }
}
