<?php

declare(strict_types=1);

class Awardit_OrderApi_BadRequestException extends Exception implements Awardit_OrderApi_ResponseException {
    private string $badRequestMessage;

    public function __construct(string $message) {
        parent::__construct("Bad Request: $message");

        $this->badRequestMessage = $message;
    }

    public function getHttpResponseCode(): int {
        return 400;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json; charset=utf-8",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => $this->badRequestMessage,
            "code" => "badRequest",
        ]);
    }

    public function getErrorLevel(): int {
        return Zend_Log::DEBUG;
    }
}
