<?php

declare(strict_types=1);

class Awardit_OrderApi_ValidationErrorException extends Exception implements Awardit_OrderApi_ResponseException {
    public function getHttpResponseCode(): int {
        return 400;
    }

    public function getHttpHeaders(): array {
        return [
            "Content-Type" => "application/json; charset=utf-8",
        ];
    }

    public function getBody(): ?string {
        return json_encode([
            "message" => $this->getMessage(),
            "code" => "validationError",
        ]);
    }

    public function getErrorLevel(): int {
        return Zend_Log::NOTICE;
    }
}
