<?php

/** @var Mage_Core_Model_Resource_Setup $this */
$installer = $this;
$connection = $installer->getConnection();

$connection->modifyColumn(
    $installer->getTable("sales/order"),
    "external_order_api_unique_id",
    [
        "type" => "text",
        "length" => 255,
        "nullable" => true,
        "default" => null,
        "comment" => "Unique external id for an order",
    ],
);
$connection->modifyColumn(
    $installer->getTable("sales/quote"),
    "external_order_api_unique_id",
    [
        "type" => "text",
        "length" => 255,
        "nullable" => true,
        "default" => null,
        "comment" => "Unique external id for an order, not enforced in quote",
    ],
);

$externalReference = [
    "type" => "text",
    "length" => 255,
    "nullable" => true,
    "default" => null,
    "comment" => "External Order API reference",
];

$connection->modifyColumn(
    $installer->getTable("sales/order"),
    "external_order_api_reference",
    $externalReference
);
$connection->modifyColumn(
    $installer->getTable("sales/quote"),
    "external_order_api_reference",
    $externalReference
);
