<?php

declare(strict_types=1);

namespace Awardit\OrderApi;

use Mage;
use Mage_Catalog_Model_Product_Status;
use Mage_Core_Model_Resource_Setup;
use Mage_Core_Model_Store;
use Mage_Sales_Model_Order;
use Mage_Sales_Model_Order_Address;
use Mage_Sales_Model_Order_Item;
use Points_Core_PointPaymentRequiredException;
use Throwable;
use Varien_Object;

use Points\Core\Extension\Quote;
use Spatie\Snapshots\MatchesSnapshots;
use Crossroads\Magento\Test\Integration\Request;
use Crossroads\Magento\Test\Integration\Config;
use Crossroads\Magento\Test\Integration\MagentoManager;

use PHPUnit\Framework\TestCase;

class ProductsControllerFilterTest extends TestCase {
    use MatchesSnapshots;

    private function setStatus(string $sku, int $status): void {
        MagentoManager::initAdmin();

        /** @var Mage_Core_Model_Store */
        $store = Mage::app()->getStore(MagentoManager::TESTING_STORE);
        $product = Mage::getModel("catalog/product");

        $product->setStoreId($store->getId());

        if ($entityId = $product->getIdBySku($sku)) {
            $product->load($entityId);
        }

        $product->addData([
            "status" => $status,
        ]);

        $product->save();

        MagentoManager::reset();
    }

    public function setUp(): void {
        MagentoManager::reset();

        Config::setConfigData("awardit_orderapi/general/enabled", "1");
        Config::setConfigData("awardit_orderapi/general/api_key", "thekey");

        $this->setStatus("test-simple", Mage_Catalog_Model_Product_Status::STATUS_DISABLED);
    }

    public function tearDown(): void {
        MagentoManager::reset();

        Config::unsetConfigData("awardit_orderapi/general/enabled");
        Config::unsetConfigData("awardit_orderapi/general/api_key");

        $this->setStatus("test-simple", Mage_Catalog_Model_Product_Status::STATUS_ENABLED);
    }

    public function onNotSuccessfulTest(Throwable $e): void {
        $this->tearDown();

        throw $e;
    }

    public function testProductsEnabled(): void {
        $resp = MagentoManager::runRequest(new Request("GET /awardit_orderapi/products?enabled=true", [
            "Authorization" => "Bearer thekey",
        ]));

        $this->assertMatchesJsonSnapshot($resp->getBody());
        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));
    }

    public function testProductsDisabled(): void {
        $resp = MagentoManager::runRequest(new Request("GET /awardit_orderapi/products?enabled=false", [
            "Authorization" => "Bearer thekey",
        ]));

        $this->assertMatchesJsonSnapshot($resp->getBody());
        $this->assertEquals(200, $resp->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));
    }
}
